using Utilities;
namespace Task02
{
    public partial class Form1 : Form
    {
        private Size panelSize = new Size(40, 40);
        private Panel lastselectedPanel = null;

        public Form1()
        {
            InitializeComponent();
            ContextMenuStrip = cmsForm;
        }

        private void cmsItemAddPanel_Click(object sender, EventArgs e)
        {
            if (sender is ToolStripItem item)
            {
                var panelCount = int.Parse(item.Tag.ToString());
                AddPanel(panelCount);
            }
        }

        private void AddPanel(int panelCount)
        {
            for (int i = 0; i < panelCount; i++)
            {
                Panel panel = new Panel
                {
                    BackColor = Utility.GetRandomColor(),
                    Size = panelSize,
                    Location=Utility.GetRandomLocationInParent(ClientSize,panelSize),
                    ContextMenuStrip=cmsPanel,
                };
                panel.Click += panel_Click;
                this.Controls.Add(panel);
            }
        }

        private void panel_Click(object? sender, EventArgs e)
        {
            if(lastselectedPanel is not null)
                lastselectedPanel.BorderStyle = BorderStyle.None;
            if (sender is Panel panel)
            { 
                panel.BorderStyle = BorderStyle.FixedSingle;
                panel.BringToFront();
                lastselectedPanel = panel;
            }
        }

        private void cmsItemRemove_Click(object sender, EventArgs e)
        {
            this.Controls.Remove(lastselectedPanel);
            lastselectedPanel = null;
        }

        private void removeAll_Click(object sender, EventArgs e)=>this.Controls.Clear();
    }
}
