﻿using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace Zadatak06
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        private Random rand = new Random();

        public MainWindow()
        {
            InitializeComponent();
        }

        private void AddPanel(object sender, RoutedEventArgs e)
        {
            StackPanel panel = new StackPanel
            {
                Width = 20,
                Height = 20,
                Margin = new Thickness(3),
                Background = GetRandomBrush(),
                LayoutTransform = GetRandomTransform()
            };

            // Children je kolekcija kontrola (kao Controls u Formsima)
            pnlContainer.Children.Add(panel);
        }

        private Transform GetRandomTransform()
        {
            return new RotateTransform(rand.Next(360));
        }

        private Brush GetRandomBrush()
        {
            Color rndColor = Color.FromRgb((byte)rand.Next(256), (byte)rand.Next(256), (byte)rand.Next(256));
            return new SolidColorBrush(rndColor);
        }

        private void RemoveAllPanels(object sender, RoutedEventArgs e)
        {
            pnlContainer.Children.Clear();
        }
    }
}