﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Task01.Models;
using System.Windows.Forms;

namespace Task01
{
    public partial class ChangePictureTitle : Form
    {
        public ChangePictureTitle(PictureBox selectedPicture)
        {
            InitializeComponent();
            InitSetup(selectedPicture);
        }

        private void InitSetup(PictureBox selectedPicture)
        {
            var pictureTitle = Utility.GetControl<Label>(selectedPicture.Parent).Text;
            txtTitle.Text = pictureTitle;
            this.Text=$"Edit {pictureTitle}";
            pb.Image = selectedPicture.Image;
        }

        public PictureBox GetUpdatePicture()
        { 
            pb.Tag=txtTitle.Text;
            return pb;
        }

        private void btnChangePicture_Click(object sender, EventArgs e)
        {
            OpenFileDialog ofd=new OpenFileDialog();
            ofd.Filter = "Picture|*.jpg;*.jpeg;*.png;*.bmp;|All files|*.*";
            ofd.InitialDirectory=Application.StartupPath;
            if(ofd.ShowDialog() == DialogResult.OK )
                pb.ImageLocation = ofd.FileName;
        }
    }
}
