namespace Zadatak01
{
    public partial class Form1 : Form
    {
        private Button initBtnStyle;

        public Form1()
        {
            InitializeComponent();

            // uzmemo button izmedju 2 i 4 ute boje
            initBtnStyle = new Button
            {
                BackColor = button2.BackColor,
                ForeColor = button2.ForeColor
            };
        }

        private void Button_MouseDown(object sender, MouseEventArgs e)
        {
            StartDragDrop(sender as Button);
        }

        private void StartDragDrop(Button? button)
        {
            // smijemo draggati samo plavi button
            if (button is null || button.BackColor == initBtnStyle.BackColor)
            {
                return;
            }

            lblInfo.Text = "Started Drag and Drop...";

            button.DoDragDrop(button, DragDropEffects.Move);
        }

        private void Button_DragEnter(object sender, DragEventArgs e)
        {
            Button? yellowButton = sender as Button;
            if (yellowButton is null || 
                yellowButton.BackColor != initBtnStyle.BackColor)
            {
                return;
            }

            lblInfo.Text = "Drop allowed...";

            // mora se poklapati s DoDragDrop efektom
            e.Effect = DragDropEffects.Move;
        }

        private void Button_DragLeave(object sender, EventArgs e)
        {
            lblInfo.Text = "Drop not allowed...";
        }

        private void Button_DragDrop(object sender, DragEventArgs e)
        {
            Button? yellowButton = sender as Button;
            if (yellowButton is null) return;

            Button? blueButton = (Button)e.Data.GetData(typeof(Button));
            if (blueButton is null) return;

            // uti postavljamo na plavi
            yellowButton.BackColor = blueButton.BackColor;
            yellowButton.ForeColor = blueButton.ForeColor;

            // plavi vraamo na uti
            blueButton.BackColor = initBtnStyle.BackColor;
            blueButton.ForeColor = initBtnStyle.ForeColor;
        }
    }
}
