namespace Task01
{
    public partial class Form1 : Form
    {
        private Color initBtnColor= Color.Yellow;
        private Button? buttonStartedDragDrop;
        public Form1()
        {
            InitializeComponent();
        }

        private void button1_DragDrop(object sender, DragEventArgs e)
        {
            Button? yellowButton = sender as Button;

            //mogli smo ga dohvatiti i preko refernce buttonStratedDragDrop
            Button? blueButton=(Button)e.Data.GetData(typeof(Button));

            //swap boja
            yellowButton.BackColor = blueButton.BackColor;
            blueButton.BackColor = initBtnColor;
        }

        private void button1_DragLeave(object sender, EventArgs e)
        {
            lblInfo.Text = "Drop not allowed!";
        }

        private void button1_DragEnter(object sender, DragEventArgs e)
        {
            Button? yelloButton = sender as Button;

            //ne moemo Droppati button na samo sebe (plavi gumb)
            if(yelloButton == buttonStartedDragDrop)
                return;

            //bitno da se Effect poklapa s Effectom iz DoDragDrop
            e.Effect = DragDropEffects.Move;
            lblInfo.Text = "Drop allowed!";
        }

        private void button1_MouseDown(object sender, MouseEventArgs e)
        {
            //zapocinje Drag and Drop
            StartDragAndDrop(sender as Button);
        }

        private void StartDragAndDrop(Button? button)
        {
            //moemo Drag and Droppati samo plavi - inicijalni gumb
            if (button is null || button.BackColor == initBtnColor) return;
            lblInfo.Text = "Started Drag and Drop";
            buttonStartedDragDrop = button;
            button.DoDragDrop(button, DragDropEffects.Move);
        }
    }
}
