using Common;
namespace Task03
{
    public partial class Form1 : Form
    {
        private Common.PayersService service = new();
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            LoadPlayers();
        }

        private void LoadPlayers()
        {
            try
            {
                List<Player> players = service.GetPalyers();
                foreach (Player p in players)
                {
                    clbPlayers.Items.Add(p);
                }
            }
            catch (Exception ex) { MessageBox.Show(ex.Message); }
        }

        private void btnLoad_Click(object sender, EventArgs e)
        {
            clbPlayers.Items.Clear();
            LoadPlayers();
        }

        private void btnRemove_Click(object sender, EventArgs e)
        {
            List<Player> selectedPlayers = new();
            foreach (Player p in clbPlayers.CheckedItems)
            { 
                selectedPlayers.Add(p);
            }
            selectedPlayers.ForEach(p=> clbPlayers.Items.Remove(p));
        }
    }
}
