namespace Task01
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private Color initColor = Color.Yellow;
        private Button? buttonStartedDragDrop;

        private void button1_MouseDown(object sender, MouseEventArgs e)
        {
            //zapoinjemo Drag and Drop
            StartDragAndDrop(sender as Button);
        }

        private void StartDragAndDrop(Button? button)
        {
            //mozemo Drag nad Dropati samo plavi gumb
            if (button is null || button.BackColor == initColor) return;
            lblInfo.Text = "Started Drag and Drop";
            buttonStartedDragDrop = button;
            button.DoDragDrop(button, DragDropEffects.Move);
        }

        private void button1_DragDrop(object sender, DragEventArgs e)
        {
            Button? yellowButton=sender as Button;

            Button? blueButton=(Button)e.Data.GetData(typeof(Button));
            //moemo ga dohvatiti i preko reference buttonStartedDragDrop

            //swap boja
            yellowButton.BackColor = blueButton.BackColor;
            blueButton.BackColor = initColor;
        }

        private void button1_DragEnter(object sender, DragEventArgs e)
        {
            Button? yelloButton=sender as Button;

            //ne moemo Dropati button na samog sebe (plavi gumb)
            if(yelloButton==buttonStartedDragDrop) return;

            //bitno je da se Effect poklapa s effectom iz DoDragDrop
            e.Effect= DragDropEffects.Move;
            lblInfo.Text = "Drop allowed";

        }

        private void button1_DragLeave(object sender, EventArgs e)
        {
            lblInfo.Text = "Drop nt allowed";
        }
    }
}
