using System.Globalization;

namespace Task08
{
    public partial class Form1 : Form
    {
        private const string HR = "hr", EN = "en";
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            SetCulture(HR);
            ShowTimeDate();
        }

        private void ShowTimeDate()
        {
            lblTime.Text = DateTime.Now.ToLongTimeString();
            lblDate.Text = DateTime.Now.ToLongDateString();
        }

        private void SetCulture(string lang)
        {
            CultureInfo culture = new CultureInfo(lang);

            //postavljamo globalizaciju (vrijem, datum, brojevi itd);
            Thread.CurrentThread.CurrentCulture = culture;
        }

        private void btnChangeCulture_Click(object sender, EventArgs e)
        {
            if (Thread.CurrentThread.CurrentCulture.Name == HR)
                SetCulture(EN);
            else
                SetCulture(HR);
            ShowTimeDate();
        }

        private void timer_Tick(object sender, EventArgs e)
        {
            ShowTimeDate();
        }
    }
}
