﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace Task03
{
    public partial class ProgressBarUC : UserControl
    {
        private Color bojaPozadine;
        public Color BojaPozadine { get { return bojaPozadine; } set { bojaPozadine = value; } }

        private Color bojaRuba;
        public Color BojaRuba { get { return bojaRuba; } set { bojaRuba = value; } }

        private Font fontPostotka;
        public Font FontPostotka { get { return fontPostotka; } set { fontPostotka = value; } }

        private string formatIspis;
        public string FormatIspis { get { return formatIspis; } set { formatIspis = value; } }

        private double progress;

        public ProgressBarUC()
        {
            InitializeComponent();

            BojaPozadine = Color.Blue;
            BojaRuba = Color.Gray;
            FontPostotka = new Font("Arial", 15);
            FormatIspis = "{0}%";

            progress = 0.5;
        }

        public void PerformStep()
        {
            progress += 0.01;
            if (progress > 1)
                progress = 0;

            //ponovno iscrtavanje kontorole
            this.Invalidate();
        }

        protected override void OnPaint(PaintEventArgs e)
        {
            base.OnPaint(e);

            //rub
            e.Graphics.DrawRectangle(new Pen(bojaRuba),0,0,this.ClientRectangle.Width-1,this.ClientRectangle.Height-1);

            //progress
            Rectangle progresRect=new Rectangle(1,1,(int)(this.ClientSize.Width*progress)-2, this.ClientSize.Height-2);
            e.Graphics.FillRectangle(new SolidBrush(bojaPozadine), progresRect);

            //postotak
            string postotak = FormatIspis.Replace("{0}", ((int)(progress * 100)).ToString());
            SizeF size = e.Graphics.MeasureString(postotak, FontPostotka);

            int y=(int)(this.ClientSize.Height-size.Height)/2;
            if (ImaMjesta(size, this.ClientSize, progresRect))
                e.Graphics.DrawString(postotak, FontPostotka, new SolidBrush(bojaPozadine), progresRect.Width + 2, y);
                //ukoliko s desne strane ima mjesta stavi ga s desne strane progress bara
            else
                e.Graphics.DrawString(postotak,FontPostotka, new SolidBrush(InverterBoje(bojaPozadine)),
                    progresRect.Width-2-size.Width, y);
            //s unutarnje strane progress bara
        }

        private Color InverterBoje(Color c)
        {
            const int MAXRGB = 255;
            return Color.FromArgb(MAXRGB - c.R, MAXRGB - c.G, MAXRGB - c.B);
        }


        //da li je Progress Bar + string veći ili manji od cijeloga kontejnera kontrole
        private bool ImaMjesta(SizeF stringSize, Size clientArea, Rectangle progresRect)
        {
            return progresRect.Width+2+stringSize.Width < clientArea.Width;
        }
    }
}
