using System.Globalization;

namespace Task09
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void ddlCulture_SelectedIndexChanged(object sender, EventArgs e)
        {
            var culture = ddlCulture.SelectedItem as Culture;
            if (culture is null) return;


            Thread.CurrentThread.CurrentCulture = culture.Value;
            ShowValue();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            foreach (var culture in CultureInfo.GetCultures(CultureTypes.AllCultures).OrderBy(k => k.Name))
            {
                ddlCulture.Items.Add(new Culture(culture.NativeName, culture));
            }
            ShowValue();
        }

        private void ShowValue()
        {
            lblDate.Text = DateTime.Now.ToLongDateString();
            lblTime.Text= DateTime.Now.ToLongTimeString();
            lblAmount.Text = (456.78).ToString();
            lblPrice.Text = (123.45).ToString("c"); // c as currency
        }
    }
}
