namespace Zadatak03
{
    public partial class Form1 : Form
    {
        private Random rand = new Random();

        public Form1()
        {
            InitializeComponent();
            CenterButton();
        }

        private void CenterButton()
        {
            int formWidth = this.ClientSize.Width;
            int formHeight = this.ClientSize.Height;

            int buttonWidth = btnChangeColorSize.Width;
            int buttonHeight = btnChangeColorSize.Height;

            int x = (formWidth - buttonWidth) / 2;
            int y = (formHeight - buttonHeight) / 2;

            btnChangeColorSize.Location = new Point(x, y);
        }

        private void btnChangeColorSize_Click(object sender, EventArgs e)
        {
            this.BackColor = GetRandomColor();
            this.Size = GetRandomSize();
            CenterButton();
        }

        private Size GetRandomSize()
        {
            int minWidth = 150;
            int minHeight = 150;
            int maxWidth = 1000;
            int maxHeight = 800;

            int width = rand.Next(minWidth, maxWidth);
            int height = rand.Next(minHeight, maxHeight);

            return new Size(width, height);
        }

        private Color GetRandomColor()
        {
            // random izmedju 0 i 255
            int r = rand.Next(0, 256);
            int g = rand.Next(0, 256);
            int b = rand.Next(0, 256);

            return Color.FromArgb(r, g, b);
        }
    }
}
