using Helper;

namespace Zadatak07
{
    public partial class Form1 : Form
    {
        private Size panelSize = new Size(100, 100);
        private Panel? lastAddedPanel;

        private const int STEP = 10;
        private const char SEPARATOR = '|';
        private const string PATH = "data.txt";

        public Form1()
        {
            InitializeComponent();
        }

        private void btnAddPanel_Click(object sender, EventArgs e)
        {
            lastAddedPanel = new Panel
            {
                Size = panelSize,
                BackColor = Utility.GetRandomColor(),
                Location = Utility
                    .GetRandomLocationInParent(this.ClientSize, panelSize)
            };

            this.Controls.Add(lastAddedPanel);
        }

        private void btnRight_Click(object sender, EventArgs e)
        {
            MovePanel(STEP, 0);
        }

        private void btnDown_Click(object sender, EventArgs e)
        {
            MovePanel(0, STEP);
        }

        private void btnLeft_Click(object sender, EventArgs e)
        {
            MovePanel(-STEP, 0);
        }

        private void btnUp_Click(object sender, EventArgs e)
        {
            MovePanel(0, -STEP);
        }

        private void MovePanel(int stepX, int stepY)
        {
            if (lastAddedPanel is null)
            {
                return;
            }

            lastAddedPanel.Location = new Point
            {
                X = lastAddedPanel.Location.X + stepX,
                Y = lastAddedPanel.Location.Y + stepY
            };
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            SaveData();
        }

        private void SaveData()
        {
            //List<string> lines = new List<string>();
            List<string> lines = new();

            foreach (Control control in this.Controls)
            {
                if (control is Panel panel)
                {
                    lines.Add($"{panel.Location.X}{SEPARATOR}" +
                        $"{panel.Location.Y}{SEPARATOR}" +
                        $"{panel.BackColor.R}{SEPARATOR}" +
                        $"{panel.BackColor.G}{SEPARATOR}" +
                        $"{panel.BackColor.B}");
                }
            }

            try
            {
                File.WriteAllLines(PATH, lines);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Error");
            }
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            LoadData();
        }

        private void LoadData()
        {
            if (!File.Exists(PATH))
            {
                return;
            }

            try
            {
                string[] lines = File.ReadAllLines(PATH);

                foreach (string line in lines)
                {
                    string[] properties = line.Split(SEPARATOR);

                    int x = int.Parse(properties[0]);
                    int y = int.Parse(properties[1]);
                    int r = int.Parse(properties[2]);
                    int g = int.Parse(properties[3]);
                    int b = int.Parse(properties[4]);

                    lastAddedPanel = new Panel
                    {
                        Size = panelSize,
                        BackColor = Color.FromArgb(r, g, b),
                        Location = new Point(x, y)
                    };

                    this.Controls.Add(lastAddedPanel);
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Error");
            }
        }
    }
}
