﻿using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using Task07.Model;
using Task07.Service;
using Task07.ViewModel;

namespace Task07
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        private AutomobilView _modelView;
        public MainWindow()
        {
            InitializeComponent();
        }

        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
            Vrsta vrsta = new Vrsta { 
            Naziv="Mazda model"
            };

            Automobil automobil = new Automobil { 
                Vrsta = vrsta,
                RegistracijskaOznaka="ZG 1234-AB",
                Boja="Crvena",
                GodinaPrveRegistracije=2025
            };
            _modelView = AutomobiliService.GetAutomobil();
            this.DataContext = _modelView;
        }

        private void Button_Click(object sender, RoutedEventArgs e)
        {
            MessageBox.Show(
                "Registracijska oznaka: " + _modelView.RegistracijskaOznaka + Environment.NewLine +
                "Boja: " + _modelView.Boja + Environment.NewLine +
                "Godina prva registracije: " + _modelView.GodinaPrveRegistracije);
        }

        private void btn_Click(object sender, RoutedEventArgs e)
        {
            _modelView.GodinaPrveRegistracije = 2000;
        }
    }
}