using System.Drawing.Printing;
using System.Globalization;
using System.Security.Authentication;

namespace Task08
{
    public partial class Form1 : Form
    {
        private const string HR = "hr";
        private const string EN = "en";
        public Form1()
        {
            InitializeComponent();
        }

        private void btnChange_Click(object sender, EventArgs e)
        {
            if (Thread.CurrentThread.CurrentCulture.Name == HR)
                SetCulture(EN);
            else SetCulture(HR);
            ShowDateTime();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            SetCulture(HR);
            ShowDateTime();
        }

        private void ShowDateTime()
        {
            lblTime.Text = DateTime.Now.ToLongTimeString();
            lblDate.Text = DateTime.Now.ToLongDateString();
        }

        private void SetCulture(string lang)
        {
            var culture = new CultureInfo(lang);
            //globalizacija
            Thread.CurrentThread.CurrentCulture = culture;

            //lokalizacija
            Thread.CurrentThread.CurrentUICulture = culture;
            ShowUI();
            ShowDateTime();
        }

        private void ShowUI()
        {
            this.Controls.Clear();
            InitializeComponent();
        }

        private void timer_Tick(object sender, EventArgs e)
        {
            ShowDateTime();
        }

        private void printDocument_EndPrint(object sender, System.Drawing.Printing.PrintEventArgs e)
        {
            if (e.PrintAction == PrintAction.PrintToPreview)
                MessageBox.Show("Finish");
        }

        private void printDocument_PrintPage(object sender, System.Drawing.Printing.PrintPageEventArgs e)
        {
            var x = e.MarginBounds.Left;
            var y = e.MarginBounds.Top;
            var bmp=new Bitmap(this.Size.Width,this.Size.Height);

            this.DrawToBitmap(bmp, new Rectangle
            {
                X = 0,
                Y = 0,
                Width = this.Size.Width,
                Height = this.Size.Height
            });
            e.Graphics?.DrawImage(bmp, x, y);
        }

        private void btnPrint_Click(object sender, EventArgs e)
        {
            printPreviewDialog.ShowDialog();
        }
    }
}
