using System.Drawing.Printing;

namespace Task1_5
{
    public partial class Form1 : Form
    {
        private int printedPageCount = 0;
        public Form1()
        {
            InitializeComponent();
        }

        private void btnPrint_Click(object sender, EventArgs e)
        {
            printDialog.ShowDialog();
        }

        private void printDocument_PrintPage(object sender, System.Drawing.Printing.PrintPageEventArgs e)
        {
            Font font = new Font("Arial", 22, FontStyle.Regular, GraphicsUnit.Pixel);
            e.Graphics?.DrawString("Hello world!", font, Brushes.Green,
                new Point(e.MarginBounds.X, e.MarginBounds.Y));

            if (++printedPageCount < numCopiesCounter.Value)
                e.HasMorePages = true;
            else
                printedPageCount = 0; //reset countera za sljedei ispis
        }

        private void printDocument_EndPrint(object sender, System.Drawing.Printing.PrintEventArgs e)
        {
            if (e.PrintAction == PrintAction.PrintToPreview)
                MessageBox.Show("PrintToPreview");
        }

        private void btnPreview_Click(object sender, EventArgs e)
        {
            printPreviewDialog.ShowDialog();
        }

        private void btnMargins_Click(object sender, EventArgs e)
        {
            pageSetupDialog.ShowDialog();
        }
    }
}
