namespace Zadatak01
{
    public partial class Form1 : Form
    {
        private PictureBox? selectedImage;

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            SetImagesCount();
        }

        private void SetImagesCount()
        {
            lblImagesCount.Text = $"Broj slika: {pnlContainer.Controls.Count}";
        }

        private void AddImage(object sender, EventArgs e)
        {
            OpenFileDialog fileDialog = new OpenFileDialog
            {
                Filter = "Slike|*.jpg;*.png|Sve datoteke|*.*"
            };
            DialogResult dialogResult = fileDialog.ShowDialog();

            if (dialogResult == DialogResult.OK)
            {
                ShowImage(fileDialog.FileName);
            }
        }

        private void ShowImage(string imagePath)
        {
            PictureBox image = GetPictureBox(imagePath);
            image.MouseClick += Image_MouseClick;
            pnlContainer.Controls.Add(image);

            SetImagesCount();
        }

        private void Image_MouseClick(object? sender, MouseEventArgs e)
        {
            PictureBox? image = sender as PictureBox;
            if (image is null) return;

            if (e.Button == MouseButtons.Left)
            {
                SelectImage(image);
            }
            else // (e.Button == MouseButtons.Right) 
            {
                UpdateImage(image);
            }
        }

        private void UpdateImage(PictureBox image)
        {
            UpdateImageForm imageForm = new UpdateImageForm(image);

            if (imageForm.ShowDialog() == DialogResult.OK)
            {
                image.Image = imageForm.GetNewImage().Image;
            }
        }

        private void SelectImage(PictureBox image)
        {
            if (selectedImage is not null)
            {
                // odselektiraj oznacenu sliku
                selectedImage.BorderStyle = BorderStyle.None;
            }

            selectedImage = image;
            selectedImage.BorderStyle = BorderStyle.Fixed3D;

            btnRemoveImage.Enabled = true;
        }

        // omjer stranica PictureBoxa (slike) je 3/2
        private PictureBox GetPictureBox(string imagePath)
        {
            int width = pnlContainer.Width / 2;

            double scale = 2 / 3.0;
            int height = (int)(width * scale);

            return new PictureBox
            {
                Size = new Size(width, height),
                ImageLocation = imagePath,
                SizeMode = PictureBoxSizeMode.StretchImage,
                // stavljamo Margin na 0 kako bi stale 2 slike jedna do druge
                Margin = new Padding(0)
            };
        }

        private void RemoveImage(object sender, EventArgs e)
        {
            pnlContainer.Controls.Remove(selectedImage);

            SetImagesCount();
            btnRemoveImage.Enabled = false;
        }

        private void SaveProject(object sender, EventArgs e)
        {
            SaveFileDialog fileDialog = new SaveFileDialog
            {
                Filter = "Tekst|*.txt"
            };

            if (fileDialog.ShowDialog() == DialogResult.OK)
            {
                HandleSavingProject(fileDialog.FileName);
            }
        }

        private void HandleSavingProject(string filePath)
        {
            List<string> lines = new List<string>();

            foreach (PictureBox image in pnlContainer.Controls)
            {
                lines.Add(image.ImageLocation);
            }

            try
            {
                File.WriteAllLines(filePath, lines);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Error");
            }
        }

        private void OpenProject(object sender, EventArgs e)
        {
            OpenFileDialog fileDialog = new OpenFileDialog
            {
                Filter = "Tekst|*.txt"
            };

            if (fileDialog.ShowDialog() == DialogResult.OK)
            {
                HandleOpeningProject(fileDialog.FileName);
            }
        }

        private void HandleOpeningProject(string filePath)
        {
            // pocisti postojece slike
            pnlContainer.Controls.Clear();

            try
            {
                string[] lines = File.ReadAllLines(filePath);

                foreach (string imagePath in lines)
                {
                    ShowImage(imagePath);
                }
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Error");
            }
        }

        private void Form1_Resize(object sender, EventArgs e)
        {
            string filePath = $"{Application.StartupPath}/temp.txt";
            HandleSavingProject(filePath);
            HandleOpeningProject(filePath);
        }
    }
}
