using Utilities;

namespace Task06
{
    public partial class Form1 : Form
    {
        private Size panelSize = new Size(200, 200);
        private Panel? addedpanel;
        public Form1()
        {
            InitializeComponent();
        }

        private void btnAddPanel_Click(object sender, EventArgs e)
        {
            Panel panel = new Panel
            {
                Size = panelSize,
                Location = Utility.GetRandomLocationInParent(pnlContainer.Size, panelSize),
                BackColor = Utility.GetRandomColor()
            };

            pnlContainer.Controls.Add(panel);
            panel.BringToFront();
            addedpanel = panel;
        }

        private void btnAddButton_Click(object sender, EventArgs e)
        {
            if(addedpanel is null) return;

            Button button= new Button { Text="Remove"};
            button.Location = Utility.GetRandomLocationInParent(addedpanel.Size, button.Size);
            button.Click += Button_Click;

            addedpanel.Controls.Add(button);
            
            button.BringToFront();
        }

        private void Button_Click(object? sender, EventArgs e)
        {
            Button? button = sender as Button;
            button?.Parent.Controls.Remove(button);
        }

        private void btnRemovePanels_Click(object sender, EventArgs e)
        {
            pnlContainer.Controls.Clear();
        }

        private void btnRemoveButtons_Click(object sender, EventArgs e)
        {
            foreach (Control control in pnlContainer.Controls)
            {
                if (control is Panel)
                    control.Controls.Clear();
            }
        }
    }
}
