using System.Collections;
using Common;
namespace Task01
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            PlayerService service = new();
            try
            {
                List<Player> players = service.GetPlayers();
                foreach (Player p in players)
                {
                    lblPlayersBench.Items.Add(p);
                }
            }
            catch (Exception ex) { MessageBox.Show(ex.Message); }
        }

        private void btnToBenchOne_Click(object sender, EventArgs e)
        {
            MovePlayers(lblPlayersPlaying, lblPlayersBench, lblPlayersPlaying.SelectedItems);
        }

        private void btnToBenchAll_Click(object sender, EventArgs e)
        {
            MovePlayers(lblPlayersPlaying, lblPlayersBench, lblPlayersPlaying.Items);
        }

        private void btnToGameAll_Click(object sender, EventArgs e)
        {
            MovePlayers(lblPlayersBench, lblPlayersPlaying, lblPlayersBench.Items);
        }

        private void btnToGameOne_Click(object sender, EventArgs e)
        {
            MovePlayers(lblPlayersBench, lblPlayersPlaying, lblPlayersBench.SelectedItems);
        }

        private void MovePlayers(ListBox fromList, ListBox toList, IEnumerable selectedItems)
        {
            List<Player> players = new();
            foreach (Player p in selectedItems)
            {
                players.Add(p);
            }

            foreach (Player p in players)
            {
                toList.Items.Add(p);
                fromList.Items.Remove(p);
            }
        }

        private void cbSort_CheckedChanged(object sender, EventArgs e)
        {
            lblPlayersBench.Sorted = lblPlayersPlaying.Sorted = cbSort.Checked;
        }
    }
}
