using Utilities;

namespace Task06
{
    public partial class Form1 : Form
    {
        private Size panelSize = new Size(200, 200);
        private Panel? addedPanel;
        public Form1()
        {
            InitializeComponent();
        }

        private void btnAddPanel_Click(object sender, EventArgs e)
        {
            Panel panel = new Panel
            { 
                Size = panelSize,
                Location=Utility.GetRadomLocationInParent(pnlContainer.Size,panelSize),
                BackColor=Utility.GetRandomColor()
            };
            pnlContainer.Controls.Add(panel);
            panel.BringToFront();
            addedPanel = panel;
        }

        private void btnAddButton_Click(object sender, EventArgs e)
        {
            if (addedPanel is null)
                return;
            Button button = new Button { Text = "Remove" };
            button.Location=Utility.GetRadomLocationInParent(addedPanel.Size,button.Size);
            button.Click += Button_Click;

            addedPanel.Controls.Add(button);
            button.BringToFront();
        }

        private void Button_Click(object? sender, EventArgs e)
        {
            Button? button = sender as Button;
            button?.Parent.Controls.Remove(button);
        }

        private void btnRemovePanels_Click(object sender, EventArgs e)
        {
            pnlContainer.Controls.Clear();
        }

        private void btnRemoveButtons_Click(object sender, EventArgs e)
        {
            foreach (Control c in pnlContainer.Controls)
            {
                if (c is Panel)
                { 
                    c.Controls.Clear() ;    
                }
            }
        }
    }
}
