namespace Task01
{
    public partial class Form1 : Form
    {
        private Color initColor = Color.Yellow;
        private Button? buttonStartedDragDrop;
        public Form1()
        {
            InitializeComponent();
        }

        private void button1_MouseDown(object sender, MouseEventArgs e)
        {
            //poetak Drag drop-a
            StartDragAndDrop(sender as Button);
        }

        private void StartDragAndDrop(Button? button)
        {
            //moemo drag and droppati samo plavi gumb
            if (button is null || button.BackColor == initColor)
                return;

            lblInfo.Text = "Started Drag & Drop!";
            buttonStartedDragDrop = button;
            button.DoDragDrop(button, DragDropEffects.Move);
        }

        private void button1_DragDrop(object sender, DragEventArgs e)
        {
            //zavretak Drag and dropa
            Button? yelloButton = sender as Button;

            Button? blueButton=(Button)e.Data.GetData(typeof(Button));
            //moemo dohvatit ga i preko reference buttonStartedDragDrop

            //swap boja
            yelloButton.BackColor = blueButton.BackColor;
            blueButton.BackColor = initColor;
        }

        private void button1_DragEnter(object sender, DragEventArgs e)
        {
            Button? yellowButton= sender as Button;

            //ne moemo Dropati boju na samog sebe (plavi gumb)
            if (yellowButton == buttonStartedDragDrop) return;

            //Bitno je da se Effect poklapa s Effekto iz DoDragDrop
            e.Effect= DragDropEffects.Move;
            lblInfo.Text = "Drop allowed";
        }

        private void button1_DragLeave(object sender, EventArgs e)
        {
            lblInfo.Text = "Drop not allowed";
        }
    }
}
