using System.Text;
using Utilities;
namespace Task0102
{
    public partial class Form1 : Form
    {

        int flpWidth = 200;
        short btnIndex;
        short panelIndex;
        FlowLayoutPanel lastAddedPanel;
        public Form1()
        {
            InitializeComponent();
        }

        private void btnAddPanel_Click(object sender, EventArgs e)
        {
            if (flowLayoutPanel.Controls.Count < 6)
                AddFlowPanel();
        }

        private void AddFlowPanel()
        {
            btnIndex = 0;
            lastAddedPanel = new FlowLayoutPanel();
            lastAddedPanel.Size = new Size(flpWidth, flpWidth);
            lastAddedPanel.Name = "FLPanel " + ++panelIndex;
            lastAddedPanel.BackColor = Utility.GetRandomColor();

            //Button part
            lastAddedPanel.FlowDirection = FlowDirection.TopDown;
            lastAddedPanel.WrapContents = false;
            lastAddedPanel.AutoScroll = true;

            flowLayoutPanel.Controls.Add(lastAddedPanel);
        }

        private void btnAddButton_Click(object sender, EventArgs e)
        {
            Button btn = new Button();
            btn.Text = String.Format("Button number {0}", ++btnIndex);
            btn.Name = "Button" + btnIndex;
            btn.Click += btn_Click;
            lastAddedPanel.Controls.Add(btn);
        }

        private void btn_Click(object? sender, EventArgs e)
        {
            Button btn = (Button)sender;
            FlowLayoutPanel panel = (FlowLayoutPanel)btn.Parent;
            panel.Controls.Remove(btn);
        }

        private void btnShow_Click(object sender, EventArgs e)
        {
            StringBuilder sb = new StringBuilder();
            if (lastAddedPanel != null)
            {
                foreach (FlowLayoutPanel panel in flowLayoutPanel.Controls)
                {
                    sb.Append(panel.Name);
                    sb.Append(Environment.NewLine);
                    foreach (Button btn in panel.Controls)
                    {
                        sb.Append("\t");
                        sb.Append(btn.Name);
                        sb.Append(Environment.NewLine);
                    }
                }
                MessageBox.Show(sb.ToString());
            }
        }
    }
}
