﻿using System.Windows;

namespace Examples
{
    public partial class ExtendedMainWindow : Window
    {
        public ExtendedMainWindow()
        {
            InitializeComponent();
        }

        private void BtnVisibility_Click(object sender, RoutedEventArgs e) => new VisibilityExample().Show();

        private void BtnButtons_Click(object sender, RoutedEventArgs e)
        {
            // ShowDialog() expects a result
            // nullable -> true if DialogResult.Ok, false if DialogResult.Cancel
            bool? value = new ButtonExample().ShowDialog();
            MessageBox.Show(value.HasValue && value.Value ? "OK" : "Cancel");
        }

        private void BtnComboBox_Click(object sender, RoutedEventArgs e) => new ComboBoxExample().Show();

        private void BtnMenu_Click(object sender, RoutedEventArgs e) => new MenuExample().Show();

        private void BtnTransform_Click(object sender, RoutedEventArgs e) => new LayoutRenderTransformExample().Show();

        private void BtnGridSplitter_Click(object sender, RoutedEventArgs e) => new GridSplitterExample().Show();
        
        private void BtnWrapPanel_Click(object sender, RoutedEventArgs e) => new WrapPanelExample().Show();

        private void BtnDock_Click(object sender, RoutedEventArgs e) => new DockPanelExample().Show();

        private void BtnCanvas_Click(object sender, RoutedEventArgs e) => new CanvasExample().Show();

        private void BtnTabControl_Click(object sender, RoutedEventArgs e) => new TabControlExample().Show();
        

        private void BtnViewBox_Click(object sender, RoutedEventArgs e) => new ViewBoxExample().Show();
        

        private void BtnRoutedEvents_Click(object sender, RoutedEventArgs e) => new RoutedEventsExample().Show();
        
    }
}
