﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Drawing.Printing;

namespace UserControlsCulturePrint
{
    public partial class UserUC : UserControl
    {
        public User User { get; private set; }

        public UserUC(User user)
        {
            InitializeComponent();
            User = user;
            SetData(user);
        }

        private void SetData(User user)
        {
            lblFirstName.Text = user.FirstName;
            lblLastName.Text = user.LastName;
        }

        private void Update_Click(object sender, EventArgs e)
        {
            var updateForm = new AddUpdateUserForm(User);

            if (updateForm.ShowDialog() == DialogResult.OK)
            {
                SetData(updateForm.GetUser());
            }
        }

        private void Print_Click(object sender, EventArgs e)
        {
            /**
             * Print Preview Dialog and all other dialogs (like OpenFileDialog, SaveFileDialog, etc) are system dialog.
             * You can not change it using .NET Localization. It depends on the language setting of your system.
             * 
             * Possible solution: You can create a custom Print Preview Dialog Form which you can localize using .NET Localization.
             */
            printPreviewDialog.Show();
        }

        private void PrintDocument_PrintPage(object sender, PrintPageEventArgs e)
        {
            Bitmap bmp = new Bitmap(pnlData.Size.Width, pnlData.Size.Height);
            pnlData.DrawToBitmap(bmp, new Rectangle
            {
                X = 0,
                Y = 0,
                Width = pnlData.Size.Width,
                Height = pnlData.Size.Height
            });

            int x = e.MarginBounds.Left;
            int y = e.MarginBounds.Top;
            e.Graphics.DrawImage(bmp, x, y);
        }

        private void DeleteUC_Click(object sender, EventArgs e)
        {
            MainForm mainForm = this.ParentForm as MainForm;
            mainForm.DeleteUC(this);
        }
    }
}
