﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Markup;
using System.Windows.Media;

namespace Examples.Extensions
{
    class GradientExtension : MarkupExtension
    {
        public override object ProvideValue(IServiceProvider serviceProvider)
        {
            var brush = new LinearGradientBrush
            {
                StartPoint = new Point(0.5, 0),
                EndPoint = new Point(0.5, 1)
            };

            var gradientStop1 = new GradientStop
            {
                Color = Colors.Yellow,
                Offset = 0
            };
            var gradientStop2 = new GradientStop
            {
                Color = Colors.Orange,
                Offset = 1
            };

            brush.GradientStops.Add(gradientStop1);
            brush.GradientStops.Add(gradientStop2);

            return brush;
        }
    }
}
