﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Drawing.Printing;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace UserControlsCulturePrint
{
    public partial class MainForm : Form
    {
        public MainForm()
        {
            InitializeComponent();
            UpdateTime();
        }

        private void UpdateTime()
        {
            statusLblTime.Text = DateTime.Now.ToLongTimeString();
        }

        private void AddUserMenuItem_Click(object sender, EventArgs e)
        {
            var addForm = new AddUpdateUserForm();

            if (addForm.ShowDialog() == DialogResult.OK)
            {
                User user = addForm.GetUser();
                pnlContainer.Controls.Add(new UserUC(user));
            }
        }

        public void DeleteUC(UserControl userControl)
        {
            pnlContainer.Controls.Remove(userControl);
        }

        private void EnglishMenuItem_Click(object sender, EventArgs e)
        {
            SetCulture("en");
        }

        private void CroatianMenuItem_Click(object sender, EventArgs e)
        {
            SetCulture("hr");
        }

        private void SetCulture(string cultureName)
        {
            // Localization
            Thread.CurrentThread.CurrentUICulture = new CultureInfo(cultureName);
            // Globalization
            Thread.CurrentThread.CurrentCulture = new CultureInfo(cultureName);

            UpdateUI();
        }

        private void UpdateUI()
        {
            var users = new List<User>();
            foreach (UserUC userUC in pnlContainer.Controls)
            {
                users.Add(userUC.User);
            }

            this.Controls.Clear();
            InitializeComponent();
            UpdateTime();

            foreach (var user in users)
            {
                pnlContainer.Controls.Add(new UserUC(user));
            }
        }

        private void Timer_Tick(object sender, EventArgs e)
        {
            UpdateTime();
        }
    }
}
