﻿using System;
using System.Windows;
using System.Windows.Markup;
using System.Windows.Media;

namespace Examples.CustomExtensions
{
    class RedLinearGradient : MarkupExtension
    {
        public override object ProvideValue(IServiceProvider serviceProvider)
        {
            return new LinearGradientBrush
            {
                StartPoint = new Point(0.5, 0),
                EndPoint = new Point(0.5, 1),
                GradientStops = new GradientStopCollection {
                    new GradientStop
                    {
                        Color = Colors.DarkRed,
                        Offset = 0
                    },
                    new GradientStop
                    {
                        Color = Colors.DarkOrange,
                        Offset = 1
                    }
                }
            };
        }
    }
}
