﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Zadatak07.Model;

namespace Zadatak07.ViewModel
{
	public class AutomobilView : INotifyPropertyChanged
	{
		public event PropertyChangedEventHandler PropertyChanged;

		private Automobil _automobil;

		public AutomobilView(Automobil automobil)
		{
			_automobil = automobil;
		}

		public Vrsta Vrsta 
		{
			get { return _automobil.Vrsta; }			
		}

		public string RegistarskaOznaka
		{
			get { return _automobil.RegistarskaOznaka; }
			set
			{
				_automobil.RegistarskaOznaka = value;

                PropertyChanged?.Invoke(this, new PropertyChangedEventArgs("RegistarskaOznaka"));
            }
		}

		public string Boja
		{
			get { return _automobil.Boja; }
			set
			{
				_automobil.Boja = value;

                PropertyChanged?.Invoke(this, new PropertyChangedEventArgs("Boja"));
            }
		}

		public int GodinaPrveRegistracije
		{
			get { return _automobil.GodinaPrveRegistracije; }
			set
			{
				_automobil.GodinaPrveRegistracije = value;

                PropertyChanged?.Invoke(this, new PropertyChangedEventArgs("GodinaPrveRegistracije"));
            }
		}
	}
}
