﻿using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace TaskLocalization
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        //Add to your App.xaml ObjectDataProvider tag
        //In App.xaml.cs add minimal provider wrapper -- getter of ObjectDataProvider from xaml and resource getter method
        //In xamls refer to all your localized texts not via

        //"{x:Static loc:Resources.MyStringKey}" 
        //(where loc is Properties namespace of your project) but

        //"{Binding Path=MyStringKey, Source={StaticResource CultureProvider}}" 
        //(where CultureProvider is the name of the ObjectDataProvider object created in step 1)

        //On localization switch refresh the provider.
        private const string HR = "hr",
            EN = "en";

        public MainWindow()
        {
            SetCulture(EN);
            InitializeComponent();
        }

        private void SetCulture(string culture)
        {
            Thread.CurrentThread.CurrentUICulture = new CultureInfo(culture);
            Thread.CurrentThread.CurrentCulture = new CultureInfo(culture);
        }

        //private void btnLanguage_Click(object sender, RoutedEventArgs e)
        //{
        //    if (Thread.CurrentThread.CurrentCulture.Name == HR)
        //    {
        //        SetCulture(EN);
        //    }
        //    else
        //    {
        //        SetCulture(HR);
        //    }
        //}

        private void btnMessage_Click(object sender, RoutedEventArgs e)
        {
            txtMessage.Text = Properties.Resources.greeting;
        }

        private void btnForm_Click(object sender, RoutedEventArgs e)
        {
            new NewWindow().Show();
        }
    }
}
