﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace TaskUserControls
{
    /// <summary>
    /// Interaction logic for ProgressControl.xaml
    /// </summary>
    public partial class ProgressControl : UserControl
    {
        public double Percentage
        {
            get => progressBar.Value;
            set
            {
                if (value < 0 || value > 100)
                {
                    return;
                }

                progressBar.Value = value;
                lblPercentage.Content = $"{value}%";
            }
        }

        public ProgressControl()
        {
            InitializeComponent();
        }

        private void UserControl_MouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            IncreasePercentage();
        }

        private void UserControl_MouseRightButtonDown(object sender, MouseButtonEventArgs e)
        {
            DecreasePercentage();
        }

        public void IncreasePercentage()
        {
            Percentage += 5;
        }

        public void DecreasePercentage()
        {
            Percentage -= 5;
        }
    }
}
