﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;

namespace Zadatak03
{
    public partial class MainWindow : Window
    {
        private List<Point> kolekcijaTocki = new List<Point>();

        public MainWindow()
        {
            InitializeComponent();
        }

        private void Canvas_MouseLeftButtonDown(object sender, MouseButtonEventArgs e)
        {
            kolekcijaTocki.Add(e.GetPosition(mojCanvas));
            IscrtajLinije();
        }

        private void Canvas_MouseRightButtonDown(object sender, MouseButtonEventArgs e)
        {
            Point klikPoint = e.GetPosition(mojCanvas);
            Label lbl = new Label();
            lbl.Content = "x";

            lbl.SetValue(Canvas.LeftProperty, klikPoint.X);
            lbl.SetValue(Canvas.TopProperty, klikPoint.Y);

            mojCanvas.Children.Add(lbl);
        }


        private void IscrtajLinije()
        {
            for (int i = 0; i < kolekcijaTocki.Count - 1; i++)
            {
                Line linija = new Line();
                linija.Stroke = this.FindResource("kist") as Brush;
                linija.StrokeThickness = 2;

                linija.X1 = kolekcijaTocki[i].X;
                linija.Y1 = kolekcijaTocki[i].Y;

                linija.X2 = kolekcijaTocki[i + 1].X;
                linija.Y2 = kolekcijaTocki[i + 1].Y;

                mojCanvas.Children.Add(linija);
            }
        }
    }
}
