﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak01
{
    internal class Window
    {
        // enkapsuliramo atribut 'title'
        private string title;

        // public property
        public string Title
        {
            get
            {
                return title;
            }
            set
            {
                title = value;
            }
        }

        // skraceno koristenje propertyja
        public string Label { get; set; }

        public bool Active { get; set; }
        public Color Color { get; set; }

        public Point TopLeft { get; set; }
        public Point BottomRight { get; set; }

        // eksplicitni konstruktor bez parametara
        public Window() : this("Window1")
        {
            //Title = "Window1";
            TopLeft = new Point(0, 0);
            BottomRight = new Point(85, 25);
        }

        // eksplicitni konstruktor s parametrom 'title'
        public Window(string title)
        {
            //this.title = title;
            Title = title;
        }

        public Window(string title, Color color, Point topLeft, Point bottomRight) : this(title)
        {
            Color = color;
            TopLeft = topLeft;
            BottomRight = bottomRight;
        }

        public void Print()
        {
            Console.WriteLine($"Title: {Title}, Label: {Label}, " +
                $"Active: {Active}, " +
                $"Color: (R: {Color.Red}, G: {Color.Green}, " +
                $"B: {Color.Blue}), " +
                $"Top Left: (X: {TopLeft.X}, Y: {TopLeft.Y}), " +
                $"Bottom Right: (X: {BottomRight.X}, Y: {BottomRight.Y})");
        }

        // pravi objektni pristup ispisa
        public override string ToString()
        {
            return $"Title: {Title}, Label: {Label}, " +
                $"Active: {Active}, " +
                $"Color: {Color}, " +
                $"Top Left: {TopLeft}, " +
                $"Bottom Right: {BottomRight}";
        }

        public int Width()
        {
            return Math.Abs(TopLeft.X - BottomRight.X);
        }

        public int Height() => Math.Abs(TopLeft.Y - BottomRight.Y);

        public int Area()
        {
            return Width() * Height();
        }

        public int Perimeter()
        {
            return 2 * (Width() + Height());
        }

        public void Draw()
        {
            // pravokutnik sa zvjezdicama prazan iznutra
            for (int i = 0; i < Height(); i++)
            {
                for (int j = 0; j < Width(); j++)
                {
                    if (i == 0 || i == Height() - 1 || j == 0 || j == Width() - 1)
                    {
                        Console.Write("*");
                    }
                    else
                    {
                        Console.Write(" ");
                    }
                }
                Console.WriteLine();
            }
        }
    }
}
