﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using TrelloRepo;
using TrelloRepo.Model;

namespace DesktopClient
{
    public partial class Form1 : Form
    {
        private static readonly IRepository repository=RepositoryFactory.GetRepository();   
        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            FillUsers();
            FillItems();
        }

        //nemožemo koriti ISet<> kao DataSource, zato koristimo List<>
        private void FillItems()=>lbItems.DataSource=repository.GetItems().ToList();

        private void FillUsers()=>cbUsers.DataSource=repository.GetUsers().ToList();

        private void btnDodaj_Click(object sender, EventArgs e)
        {
            if (FormValid())
            {
                repository.AddItem(new Item
                {
                    Datum = dtpDatum.Value,
                    Opis = tbOpis.Text.Trim(),
                    Id = int.Parse(tbId.Text),
                    User = cbUsers.SelectedItem as User
                });
                FillItems();
                ClearForm();
            }
        }

        private void ClearForm()
        {
            tbId.Text = string.Empty;
            tbOpis.Text = string.Empty;
            dtpDatum.Value=DateTime.Now;
        }

        private bool FormValid()
        {
            if (!int.TryParse(tbId.Text.Trim(), out int id))
            {
                MessageBox.Show("Unesite ispravan ID");
                tbId.Focus();
                return false;
            }
            if (string.IsNullOrEmpty(tbOpis.Text))
            {
                MessageBox.Show("Unesite opis!");
                tbOpis.Focus();
                return false;
            }
            return true;
        }
    }
}
