﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace TrelloRepo.Model
{
    public class Item
    {
        private const char DELIMITER = '|'; //možemo koristi isti i za Uder i za Item ili možemo korisit raličit
        private const string DATE_FORMAT = "dd:MM:yyyy";

        public int ID {  get; set; }
        public string Opis { get; set; }
        public DateTime Datum { get; set; }
        public User User { get; set; }

        public override string ToString()=>$"{Opis}, {Datum.ToString(DATE_FORMAT)}, {User}";
        public override bool Equals(object obj)=>obj is Item other ? ID == other.ID : false ;
        public override int GetHashCode()=>ID.GetHashCode() ;

        internal string FormatForFileLine() => $"{ID}{DELIMITER}{Opis}{DELIMITER}{Datum.ToString(DATE_FORMAT)}{DELIMITER}{User.FormatForFileLine()}";

        internal static Item ParseFromFileLine(string line)
        {
            string[] details = line.Split(DELIMITER) ;
            return new Item
            {
                ID = int.Parse(details[0]),
                Opis = details[1],
                Datum = DateTime.ParseExact(details[2], DATE_FORMAT, null),
                User = User.ParseFromFileLine(details[3])
            };
        }
    }
}
