﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace TrelloRepo.Model
{
    public class User
    {
        private const char DELIMITER = '#';
        public int ID { get; set; }
        public string Ime {  get; set; }
        public string Prezime  { get; set; }

        public override string ToString() => $"{Ime} {Prezime}";
        public override bool Equals(object obj)=>obj is User other ? ID == other.ID : false ;
        public override int GetHashCode()=>ID.GetHashCode() ;

        internal string FormatForFileLine() => $"{ID}{DELIMITER}{Ime}{DELIMITER}{Prezime}";
        internal static User ParseFromFileLine(string line)
        {
            string[] details = line.Split(DELIMITER) ;
            return new User
            {
                ID = int.Parse(details[0]),
                Ime = details[1],
                Prezime = details[2]
            };
        }
    }
}
