﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak02
{
    internal class Frog
    {
        public int NumberOfLegs { get; set; }

        // Provjera da boja ima 6 slova
        // Color se ne moze izvana mijenjati
        private string color;
        public string Color
        {
            get
            {
                return color;
            }
            private set
            {
                if (!IsValid(value))
                {
                    throw new Exception("Color must have 6 letters");
                }
                color = value;
            }
        }

        public Frog(int numberOfLegs, string color)
        {
            NumberOfLegs = numberOfLegs;
            Color = color;
        }

        private bool IsValid(string value)
        {
            if (value.Length != 6)
            {
                return false;
            }

            foreach (char c in value)
            {
                if (!char.IsLetter(c))
                {
                    return false;
                }
            }

            return true;
        }

        public override bool Equals(object obj)
        {
            return obj is Frog frog &&
                   NumberOfLegs == frog.NumberOfLegs &&
                   Color == frog.Color;
        }

        public override int GetHashCode()
        {
            int hashCode = 997427848;
            hashCode = hashCode * -1521134295 + NumberOfLegs.GetHashCode();
            hashCode = hashCode * -1521134295 + EqualityComparer<string>.Default.GetHashCode(Color);
            return hashCode;
        }

        public override string ToString()
        {
            return $"Num. of legs: {NumberOfLegs}, Color: {Color}";
        }

        public static bool operator ==(Frog left, Frog right)
        {
            return EqualityComparer<Frog>.Default.Equals(left, right);
        }

        public static bool operator !=(Frog left, Frog right)
        {
            return !(left == right);
        }
    }
}
