﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak01
{
    internal class Program
    {
        static void Main(string[] args)
        {
            // Program to an interface, not an implementation
            ISwitchable switchableLight = new LightBulb(12, 10);
            Console.WriteLine(switchableLight);
            
            switchableLight.SwitchOn();
            switchableLight.SwitchOff();

            Console.WriteLine();

            ISwitchable switchableStove 
                = new Stove("Bosch", Stove.StoveType.Electric);
            Console.WriteLine(switchableStove);

            switchableStove.SwitchOn();
            switchableStove.SwitchOff();

            Console.WriteLine();

            // implentaciju liste spremamo u IList interface
            IList<ISwitchable> switchables = new List<ISwitchable>();
            switchables.Add(switchableLight);
            switchables.Add(switchableStove);
            switchables.Add(new Stove("Gorenje", Stove.StoveType.Gas));

            switchables.Add(new UniversalRemoteContoller());

            foreach (ISwitchable s in switchables)
            {
                Console.WriteLine(s);

                if (s is IRemoteController remote)
                {
                    remote.VolumeUp();
                }
            }
        }
    }
}
