﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Task.Solution;

namespace Task
{
    internal class Program
    {
        static void Main(string[] args)
        {
            //ShowProblem();
            ShowSolution();
        }

        // problems:
        // 1. all pizzas are the same - we could introduce inheritance, but after all, they are different only in properties Ingredients and Price - so we could end up with pizza only!
        // 2. main should not be pizzeria - all the work (prepare, bake, serve, charge) done on the service side, not client side; client should only enjoy pizza!
        private static void ShowProblem()
        {
            // we must use namespace because of ambiguity - we have two Margherita classes imported!
            Problem.Margherita margherita = new Problem.Margherita();
            margherita.Prepare();
            margherita.Bake();
            margherita.Serve();
            margherita.Charge();
            Console.WriteLine($"Enjoying: {margherita}");
            Console.WriteLine();

            Problem.Capricciosa capricciosa = new Problem.Capricciosa();
            capricciosa.Prepare();
            capricciosa.Bake();
            capricciosa.Serve();
            capricciosa.Charge();
            Console.WriteLine($"Enjoying: {capricciosa}");
        }
        private static void ShowSolution()
        {
            // this is the only thing that should happen on the client:
            // 1. we order the pizza
            // 2. we enjoy the pizza
            // notice that we speak through protocol - we do not use Capricciosa class, but consider it Pizza -> the client does not depend on implementation, but on the concept!
            Pizza capricciosa = Solution.PizzaFactory.GetPizza("Capricciosa");
            Console.WriteLine($"Enjoying: {capricciosa}");
            Console.WriteLine();

            // we introduce new type of pizza - how many things need to change:
            // 1. create new class (Vegetariana)
            // 2. change PizzaFactory and put new case block
            Pizza vegetariana = PizzaFactory.GetPizza("Vegetariana");
            Console.WriteLine($"Enjoying: {vegetariana}");
            Console.WriteLine();

            // we have 2 new problems:
            // 1. we must change PizzaFactory and put new case block every time new Pizza comes along
            // 2. it is very difficult not to make mistake by specifying "Capricciosa" as an argument, we could use "Capricosa" and the system wouldn't work because of one character
            // we can do better -> reflection!!! - this is not obligatory subject - it will not be on the exam!!!
            // we must provide full name (namespace.classname to the method!!!)
            Pizza margherita = PizzaFactory.GetPizzaByReflection(typeof(Solution.Margherita).FullName);
            Console.WriteLine($"Enjoying: {margherita}");
            Console.WriteLine();

            // we introduce new type of pizza - how many things need to change:
            // 1. create new class (AlTonno)
            // that's it :)
            Pizza alTonno = PizzaFactory.GetPizzaByReflection(typeof(Solution.AlTonno).FullName);
            Console.WriteLine($"Enjoying: {alTonno}");
        }
    }
}
