﻿using System;

namespace PodatkovniSloj
{
    public class User
    {
        public int Id { get; set; }
        public string FirstName { get; set; }
        public string LastName { get; set; }

        private const char SEPARATOR = '#';

        public override string ToString()
        {
            return $"[{Id}] {FirstName} {LastName}";
        }

        public string FormatForFile()
        {
            return $"{Id}{SEPARATOR}{FirstName}{SEPARATOR}{LastName}";
        }

        public static User ParseFromFile(string line)
        {
            string[] properties = line.Split(SEPARATOR);

            return new User
            {
                Id = int.Parse(properties[0]),
                FirstName = properties[1],
                LastName = properties[2]
            };
        }
    }
}