﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak01
{
    class Program
    {
        static void Main(string[] args)
        {
            // we start by creating Point class, because is most simple one in hierarchy 
            PointDemo();
            // next one is Color
            ColorDemo();
            WindowDemo();
        }
        private static void PointDemo()
        {
            // where does this Constructor comes from? it is a default parameterless Constructor that we get from language implementation
            //Point point = new Point();
            // if we use point. there are also many methods to call (ToString(), Equals()...) - where are they coming from?

            // the default constructor puts object in correct state
            //Console.WriteLine(point.x);
            // the point is not on the screen - we must protect access to instance variables!
            //point.x = -1;

            // now that we have Properties, we can check default values - 0, 0
            // so, the duty of the constructor is to put object in correct state (all variables on heap are initialized on default values)
            //Console.WriteLine(point.X);
            //Console.WriteLine(point.Y);

            // this is not possible any more!
            //point.X = -1;
            
            //point.X = 1;
            //point.Y = 2;
            //Console.WriteLine(point.X);
            //Console.WriteLine(point.Y);

            // but, we are using 3 lines of code, just to create a proper Point - can we use Constructor?
            // when we introduced our own constructor, we have lost a default, parameterless one!
            Point point = new Point(1, 2);

            // can we print point? 
            //point.PrintDetails();

            // these two method calls have the same result because Console.WriteLine() calls ToString() on passed object
            // how can the method Console.WriteLine() be sure there is a ToString() method? EVERY CLASS EXTENDS OBJECT and we inherit the methods from it
            //Console.WriteLine(point.ToString());
            Console.WriteLine(point);
        }
        private static void ColorDemo()
        {
            Color color = new Color(0, 255, 0);
            Console.WriteLine(color);
        }
        private static void WindowDemo()
        {
            Window window = new Window();
            Console.WriteLine(window);

            window.Title = "Window";
            window.Label = "w1";
            window.TopLeft = new Point(1, 1);
            window.BottomRight = new Point(10, 10);
            window.Color = new Color(0, 255, 255);
            window.IsActive = true;
            Console.WriteLine(window);

            Console.WriteLine($"Width: {window.Width()}");
            Console.WriteLine($"Height: {window.Height()}");

            Console.WriteLine("Area: {0}", window.Area());
            Console.WriteLine("Perimeter: {0}", window.Perimeter());
            window.DrawFill();
            window.DrawBorder();

            Window window2 = new Window("Window2", "w2", new Point(10, 10), new Point(20, 15), new Color(255, 0, 0), true);
            Console.WriteLine(window2);

            Window window3 = new Window("Window3");
            Console.WriteLine(window3);
        }
    }
}
