﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak04
{
    internal class Program
    {
        static void Main(string[] args)
        {
            ShowProblem();
            ShowSolution();
        }

        private static void ShowSolution()
        {
            //1. moramo pozvati metodu call
            //2. bacamo exception za tu metodu
            //3. catch
            //4. stvaranje dokumentacije

            try
            {
                double num = 10;
                double den = 0;
                double djeljenje = Divide(num, den);
                Console.WriteLine(djeljenje);
            }
            catch (DivideByDoubleZeroException ex)
            {
                Console.WriteLine(ex.Message);
            }
        }

        /// <summary>
        /// Dijeljenje dva broja, ukoliko nisu nula, inače dobivamo grešku
        /// </summary>
        /// <param name="num"></param>
        /// <param name="den"></param>
        /// <returns> </returns>
        /// <exception cref="DivideByDoubleZeroException"></exception>
        private static double Divide(double num, double den)
        {
            if (den == 0)
            {
                throw new DivideByDoubleZeroException($"{num} / {den} ne moze se podijeliti!");
            };
            return num / den;
        }

        private static void ShowProblem()
        {
            //PROBLEM
            Console.WriteLine(10 / 0.0);
            Console.WriteLine(0 / 0.0);

            //jedan način rješenja
            if(double.IsInfinity(10/0.0))
                Console.WriteLine("Infinity");
            if (double.IsNaN(0 / 0.0))
                Console.WriteLine("Nije broj");
            //ovo nije rješenje, jer ne, neomogućuje dijelenje sa 0!
        }
    }
}
