﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak03
{
    internal class Program
    {
        static void Main(string[] args)
        {
            ClientHost host = new ClientHost();
            ClientHostImproved hostImproved = new ClientHostImproved();

            // Subscribe
            host.OnClientArrived += CallTeam;
            hostImproved.OnClientArrived += CallTeamImproved;
            host.OnClientArrived += CallSupervisor;
            hostImproved.OnClientArrived += CallSupervisorImproved;
            // Subscribe with Lambda
            host.OnClientArrived += (client) =>
            {
                Console.WriteLine($"Arrange a meeting with {client}");
            };
            hostImproved.OnClientArrived += (sender, e) =>
            {
                Console.WriteLine($"Arrange a meeting with {e.Client}");
            };

            // Unsubscribe
            host.OnClientArrived -= CallTeam;
            hostImproved.OnClientArrived -= CallTeamImproved;

            // Publish
            host.ClientHasArrived(new Client
            {
                FirstName = "Pero",
                LastName = "Peric"
            });
            hostImproved.ClientHasArrived(new Client
            {
                FirstName = "Ana",
                LastName = "Anic"
            });
        }

        private static void CallSupervisorImproved(object sender, 
            ClientEventArgs e)
        {
            Console.WriteLine($"Dear Supervisor, {e.Client} has arrived");
        }

        private static void CallTeamImproved(object sender, 
            ClientEventArgs e)
        {
            Console.WriteLine($"Hello Team, {e.Client} has arrived");
        }

        private static void CallSupervisor(Client client)
        {
            Console.WriteLine($"Dear Supervisor, {client} has arrived");
        }

        private static void CallTeam(Client client)
        {
            Console.WriteLine($"Hello Team, {client} has arrived");
        }
    }
}
