﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Task01
{
    internal class Program
    {
        static void Main(string[] args)
        {
            //Step1();
            //Step2();
            //Step3();
            //Step4();
            //Step5();
            Step6();

        }

        // explains Exception and StackTrace
        private static void Step1()
        {
            //int index = 10 / 0; //this does not compile, because it is const, but we can trick it with a variable!
            int n = 0;
            int index = 10 / n;
            Console.WriteLine("This code will never be reached!");
        }

        // ctrl + k + s -> try catch block
        private static void Step2()
        {
            try
            {
                int n = 0;
                int index = 10 / n;
                Console.WriteLine("This code will never be reached!");
            }
            catch
            {
                Console.WriteLine("All exceptions handled");
            }
            Console.WriteLine("This code will be reached");
        }
        // finally block
        private static void Step3()
        {
            try
            {
                //return; // finally block will be reached!
                //Environment.Exit(0); // finally block will not be reached!
                int n = 0;
                int index = 10 / n;
                Console.WriteLine("This code will never be reached!");
            }
            catch
            {
                Console.WriteLine("All exceptions handled");
            }
            finally
            {
                Console.WriteLine("Block that always executes");
            }
            Console.WriteLine("This code will be reached");
        }

        // handle specific Exceptions - from most specific to least specific!
        private static void Step4()
        {
            try
            {
                int n = 0;
                int index = 10 / n;
                Console.WriteLine("This code will never be reached!");
            }
            catch (DivideByZeroException)
            {
                Console.WriteLine("DivideByZeroException");
            }
            catch (ArithmeticException)
            {
                Console.WriteLine("ArithmeticException");
            }
            catch (Exception) // basically the same as catch with no exception in the brackets
            {
                Console.WriteLine("All exceptions handled");
            }
        }
        // handle Exceptions as an object and read properties!
        private static void Step5()
        {
            try
            {
                int n = 0;
                int index = 10 / n;
                Console.WriteLine("This code will never be reached!");
            }
            catch (DivideByZeroException e)
            {
                Console.WriteLine($"Type:{e.GetType()}");
                Console.WriteLine($"Stack trace:{e.StackTrace}");
                Console.WriteLine($"Message:{e.Message}");
            }
        }

        // handle MultipleExceptions
        private static void Step6()
        {
            try
            {
                int n = 10; // 0, 1
                int index = 10 / n;

                int[] array = { 1, 2, 3 };
                Console.WriteLine(array[index]);

                int i = int.Parse("Milica");
                //int.Parse("123456789012345"); //throws OverFlowException
                //int.Parse(null); //throws ArgumentNullException

                Console.WriteLine("This code will never be reached!");
            }
            catch (DivideByZeroException e)
            {
                Console.WriteLine($"Type:{e.GetType()}");
                Console.WriteLine($"Stack trace:{e.StackTrace}");
                Console.WriteLine($"Message:{e.Message}");
            }
            catch (IndexOutOfRangeException e)
            {
                Console.WriteLine($"Type:{e.GetType()}");
                Console.WriteLine($"Stack trace:{e.StackTrace}");
                Console.WriteLine($"Message:{e.Message}");
            }
            //catch (FormatException e)
            catch (Exception e)
            {
                Console.WriteLine($"Type:{e.GetType()}");
                Console.WriteLine($"Stack trace:{e.StackTrace}");
                Console.WriteLine($"Message:{e.Message}");
            }
        }
    }
}
