﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Task02
{
    internal class Program
    {
        private const string PATH = @"C:\Users\daniel.bele\Desktop\data\text.txt";

        static void Main(string[] args)
        {
            //ReadFileTest(PATH);
            try
            {
                WriteFile(PATH, "trla baba lan, da joj prodje dan");
                ReadFile(PATH);
            }
            catch (Exception e) // since we are not doing anything different for different exceptions, we can catch them all in the same manner
            {
                Console.WriteLine(e.Message);
            }
            UsingDemo();
        }

        private static void ReadFileTest(string path)
        {
            // step 1 - file not created, exceptions not handled! NOT GOOD!
            //StreamReader reader = File.OpenText(path);
            //Console.WriteLine(reader.ReadToEnd());
            //reader.Dispose(); // close

            // step 2. - catch multiple exceptions
            // when we create directory, we get a FileNotFoundException!
            // but, when we hover File.OpenText, we see many exceptions - let us put catch(Exception) for all other exceptions
            // we have a big problem! - reader.Dispose() should be in the finally block!
            // but, then we have to put it in the outer scope and initialize to null!!!
            // but, then we have to also check for null before Dispose()!!
            // there has got to be a better solution!!! - USING STATEMENT!
            StreamReader reader = null;
            try
            {
                //StreamReader reader = File.OpenText(PATH);
                reader = File.OpenText(PATH);
                Console.WriteLine(reader.ReadToEnd());
                //reader.Dispose();
            }
            catch (DirectoryNotFoundException e)
            {
                Console.WriteLine(e.Message);
            }
            catch (FileNotFoundException e)
            {
                Console.WriteLine(e.Message);
            }
            catch (Exception e)
            {
                Console.WriteLine(e.Message);
            }
            finally
            {
                //if (reader != null)
                //{
                //    reader.Dispose();

                //}           
                reader?.Dispose(); // lucky for us, there is a NULL CONDITIONAL OPERATOR, but this is still too complicated!
            }
        }

        // ReadFile is not responsible if there is no FILE, but is responsible for CLOSING the FILE
        // the caller (main) should be in try catch block, because he is resposible if there is no FILE
        private static void ReadFile(string path)
        {
            using (StreamReader reader = File.OpenText(PATH))
            {
                Console.WriteLine(reader.ReadToEnd());
            } // at the end of using block, the code automatically calls Dispose() !!!
        }

        private static void WriteFile(string path, string text)
        {
            //if we remove using, the file will not be disposed, hence we cannot read it afterwards
            using (StreamWriter writer = File.CreateText(PATH))
            {
                writer.WriteLine(text);
            }
        }

        private static void UsingDemo()
        {
            using (Dummy dummy = new Dummy())
            {
                //throw new Exception();
                //return;
            } // it prints, it is a proof that Dispose() is called by the system, even if we throw exception or return
        }
    }
}
