﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ParameterPassing
{
    class Program
    {
        static void Main(string[] args)
        {
            int i = 1; // must be assigned a value, before passed to a method!
            PassByValue(i);
            Console.WriteLine($"Value->Main: {i}");

            int j;
            j = 1; // must be assigned a value, before passed to a method as ref!
            PassByRef(ref j);
            Console.WriteLine($"Ref->Main: {j}");

            //int k; // does not have to be assigned a value before passed to a method as out!
            //k = 0; // can be assigned, but it makes no sense
            //PassByOut(out k);
            // one liner - deklaration and pass:
            PassByOut(out int k);
            Console.WriteLine($"Out->Main: {k}");

            List<int> list = new List<int>();
            PassByReference(list);
            Console.WriteLine($"Reference->Main: {list.Count}");
        }
        private static void PassByValue(int i)
        {
            i++;
            Console.WriteLine($"Value->Method: {i}");
        }
        private static void PassByRef(ref int j)
        {
            j++;
            Console.WriteLine($"Ref->Method: {j}");
        }
        private static void PassByOut(out int k)
        {
            k = 1; // must be assigned
            k++;
            Console.WriteLine($"Out->Method: {k}");
        }
        private static void PassByReference(List<int> list)
        {
            list.Add(1);
            Console.WriteLine($"Reference->Method: {list.Count}");
        }
    }
}
