﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace TrelloRepo.Model
{
    public class User
    {
        private const char Del = '|';
        public int Id { get; set; }
        public string FirstName { get; set; }
        public string LastName { get; set; }
        public override string ToString() => $"{FirstName} {LastName}";
        public string Format() => $"{Id}{Del}{FirstName}{Del}{LastName}";

        public static User Parse(string line)
        {
            string[] details = line.Split(Del);
            return new User
            {
                Id = int.Parse(details[0]),
                FirstName = details[1],
                LastName = details[2]
            };
        }

        public override bool Equals(object obj) => obj is User other && Id == other.Id;
        public override int GetHashCode() => Id.GetHashCode();


      
    }
}
