﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak
{
    public class FileRepository : IRepository
    {
        private const string PATH = "people.txt";

        public void AddPerson(Person person)
        {
            string content = $"{Environment.NewLine}{person.FormatForFile()}";
            File.AppendAllText(PATH, content);
        }

        public IList<Person> GetPeople()
        {
            IList<Person> list = new List<Person>();

            string[] lines = File.ReadAllLines(PATH);
            //lines.ToList().ForEach(str => list.Add(Person.Parse(str)));
            foreach (string line in lines)
            {
                Person person = Person.Parse(line);
                list.Add(person);
            }

            return list;
        }
    }
}
