﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak
{
    public class PeopleManager
    {
        public delegate void PersonLoadedDelegate(
            object sender, PersonEventArgs args);
        public event PersonLoadedDelegate OnPersonLoaded;

        private IRepository repo = RepositoryFactory.GetRepository();

        public void AddPerson(Person person)
        {
            repo.AddPerson(person);
        }

        public Dictionary<string, Person> LoadPeople()
        {
            Dictionary<string, Person> peopleDict = new Dictionary<string, Person>();

            IList<Person> people = repo.GetPeople();
            foreach (Person person in people)
            {
                // koristimo try-catch unutar foreachea kako bi
                // probali ucitati svaku osobu
                try
                {
                    if (!person.HasValidOib())
                    {
                        throw new InvalidOibException();
                    }

                    peopleDict.Add(person.OIB, person);

                    OnPersonLoaded?.Invoke(this, new PersonEventArgs
                    {
                        Person = person
                    });
                }
                catch (Exception ex)
                {
                    Console.WriteLine(ex.Message);
                }
            }

            return peopleDict;
        }
    }
}
