﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net.Mail;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak
{
    public class Person
    {
        public string OIB { get; set; }
        public string FirstName { get; set; }
        public string LastName { get; set; }
        public string Phone { get; set; }
        public string Email { get; set; }

        private const char SEPARATOR = '|';

        public static Person Parse(string line)
        {
            string[] properties = line.Split(SEPARATOR);

            return new Person
            {
                OIB = properties[0],
                FirstName = properties[1],
                LastName = properties[2],
                Phone = properties[3],
                Email = properties[4]
            };
        }

        public override string ToString()
        {
            return $"[{OIB}] {FirstName} {LastName}, " +
                $"Phone: {Phone}, Email: {Email}";
        }

        public bool HasValidOib()
        {
            //return OIB.All(c => char.IsDigit(c));
            return OIB.All(char.IsDigit);
        }

        public string FormatForFile()
        {
            return $"{OIB}{SEPARATOR}{FirstName}{SEPARATOR}{LastName}{SEPARATOR}" +
                $"{Phone}{SEPARATOR}{Email}{SEPARATOR}";
        }
    }
}
