﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak01
{
    class ComplexNumber : Object // this is implicit inheritance 
    {
        public int Re { get; set; }
        public int Im { get; set; }
        public override string ToString() => $"{Re}{(Im < 0 ? "" : "+")}{Im}i";

        //public override bool Equals(object obj)
        //{
        //    // 1.st step
        //    //if (obj is ComplexNumber) // is operator
        //    //{
        //    //    //ComplexNumber other = (ComplexNumber)obj; // explicit cast
        //    //    ComplexNumber other = obj as ComplexNumber; // as operator
        //    //    return Re == other.Re && Im == other.Im;
        //    //}
        //    // 2.nd step - the code can be simplified:
        //    if (obj is ComplexNumber other) // is and as operators together!
        //    {
        //        return Re == other.Re && Im == other.Im;
        //    }
        //    return false;
        //}
        // 3.rd step - ternary:
        //public override bool Equals(object obj) => obj is ComplexNumber other ? Re == other.Re && Im == other.Im : false;
        // 4th step - simplified:
        public override bool Equals(object obj) => obj is ComplexNumber other && Re == other.Re && Im == other.Im;

        // if we used Re.GetHashCode() + Im.GetHashCode(), then 3 + 2i and 2 + 3i would fall in the same bucket!
        public override int GetHashCode() => Re.GetHashCode() * 31 / Im.GetHashCode(); // use prime numbers!

        // operator overloading
        public static bool operator ==(ComplexNumber a, ComplexNumber b) => a.Re == b.Re && a.Im == b.Im;
        
        //public static bool operator !=(ComplexNumber a, ComplexNumber b) => a.Re != b.Re || a.Im != b.Im;
        // above can be simplified:
        public static bool operator !=(ComplexNumber a, ComplexNumber b) => !(a == b);
    }
}
