﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Zadatak04
{
    class Program
    {
        static void Main(string[] args)
        {
            // abstract class can not be instantiated!
            //GeometricalFigure figure = new GeometricalFigure("red");
            GeometricalFigure rectangle = new Rectangle("red", 12, 8);
            GeometricalFigure circle = new Circle("blue", 1);
            IList<GeometricalFigure> figures = new List<GeometricalFigure>
            {
                rectangle,
                circle,
                new Triangle("green", 3, 4, 5)
            };

            // default ToString() of Object actually calls GetType()!
            //foreach (var figure in figures)
            //{
            //    Console.WriteLine($"Area of {figure.GetType()}: {figure.Area()}");
            //    Console.WriteLine($"Perimeter of {figure}: {figure.Perimeter()}");
            //}

            // above can be rewritten to lambda:
            figures.ToList().ForEach(figure =>
            {
                Console.WriteLine($"Area of {figure.GetType()}: {figure.Area()}");
                Console.WriteLine($"Perimeter of {figure}: {figure.Perimeter()}");
            });
        }
    }
}
